/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.agriculture;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.IBerryBush;
import net.dries007.tfc.api.util.IGrowingPlant;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.DamageSourcesTFC;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockBerryBush
extends Block
implements IGrowingPlant {
    public static final PropertyBool FRUITING = PropertyBool.func_177716_a((String)"fruiting");
    private static final AxisAlignedBB SMALL_SIZE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB MEDIUM_SIZE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final Map<IBerryBush, BlockBerryBush> MAP = new HashMap<IBerryBush, BlockBerryBush>();
    private final IBerryBush bush;

    public static BlockBerryBush get(IBerryBush bush) {
        return MAP.get(bush);
    }

    public BlockBerryBush(IBerryBush bush) {
        super(Material.field_151585_k);
        this.bush = bush;
        if (MAP.put(bush, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FRUITING, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FRUITING, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FRUITING) != false ? 1 : 0;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.bush.getSize() == IBerryBush.Size.LARGE;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (this.bush.getSize()) {
            case SMALL: {
                return SMALL_SIZE_AABB;
            }
            case MEDIUM: {
                return MEDIUM_SIZE_AABB;
            }
        }
        return field_185505_j;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (this.bush.getSize() == IBerryBush.Size.LARGE && face == EnumFacing.UP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        TETickCounter te;
        if (!world.field_72995_K && (te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class)) != null) {
            float temp = ClimateTFC.getActualTemp(world, pos);
            float rainfall = ChunkDataTFC.getRainfall(world, pos);
            long hours = te.getTicksSinceUpdate() / 1000L;
            if ((double)hours > (double)this.bush.getGrowthTime() * ConfigTFC.General.FOOD.berryBushGrowthTimeModifier && this.bush.isValidForGrowth(temp, rainfall)) {
                if (this.bush.isHarvestMonth(CalendarTFC.CALENDAR_TIME.getMonthOfYear())) {
                    world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FRUITING, (Comparable)Boolean.valueOf(true)));
                }
                te.resetCounter();
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!this.canStay((IBlockAccess)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TETickCounter tile = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
        if (tile != null) {
            tile.resetCounter();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        if (super.func_176196_c(worldIn, pos)) {
            return this.canStay((IBlockAccess)worldIn, pos);
        }
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)FRUITING)).booleanValue()) {
            if (!worldIn.field_72995_K) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)this.bush.getFoodDrop());
                worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)FRUITING, (Comparable)Boolean.valueOf(false)));
                TETickCounter te = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
                if (te != null) {
                    te.resetCounter();
                }
            }
            return true;
        }
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityPlayer) || !((EntityPlayer)entityIn).func_184812_l_()) {
            entityIn.field_70159_w *= ConfigTFC.General.MISC.berryBushMovementModifier;
            if (entityIn.field_70181_x < 0.0) {
                entityIn.field_70181_x *= ConfigTFC.General.MISC.berryBushMovementModifier;
            }
            entityIn.field_70179_y *= ConfigTFC.General.MISC.berryBushMovementModifier;
            if (this.bush.isSpiky() && entityIn instanceof EntityLivingBase) {
                entityIn.func_70097_a(DamageSourcesTFC.BERRYBUSH, 1.0f);
            }
        }
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FRUITING});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TETickCounter();
    }

    @Nonnull
    public IBerryBush getBush() {
        return this.bush;
    }

    private boolean canStay(IBlockAccess world, BlockPos pos) {
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        if (this.bush.getSize() == IBerryBush.Size.LARGE && below.func_177230_c() instanceof BlockBerryBush && ((BlockBerryBush)below.func_177230_c()).bush == this.bush) {
            return BlocksTFC.isGrowableSoil(world.func_180495_p(pos.func_177979_c(2)));
        }
        return BlocksTFC.isGrowableSoil(below);
    }

    @Override
    public IGrowingPlant.GrowthStatus getGrowingStatus(IBlockState state, World world, BlockPos pos) {
        float temp = ClimateTFC.getActualTemp(world, pos);
        float rainfall = ChunkDataTFC.getRainfall(world, pos);
        boolean canGrow = this.bush.isValidForGrowth(temp, rainfall);
        if (((Boolean)state.func_177229_b((IProperty)FRUITING)).booleanValue()) {
            return IGrowingPlant.GrowthStatus.FULLY_GROWN;
        }
        if (canGrow && this.bush.isHarvestMonth(CalendarTFC.CALENDAR_TIME.getMonthOfYear())) {
            return IGrowingPlant.GrowthStatus.GROWING;
        }
        return canGrow ? IGrowingPlant.GrowthStatus.CAN_GROW : IGrowingPlant.GrowthStatus.NOT_GROWING;
    }
}

